# Tjuridico.com.br - Website Futurista com Agentes de IA

## Design Guidelines

### Design References (Primary Inspiration)
- **Apple.com**: Clean, minimalist, premium feel with subtle animations
- **Stripe.com**: Smooth micro-interactions, gradient backgrounds
- **Linear.app**: Futuristic aesthetic, glassmorphism effects
- **Style**: Clean Futurism + Glassmorphism + Cyberpunk Minimalism

### Color Palette
- Primary: #0A0A0F (Deep Space Black - background)
- Secondary: #1A1A2E (Midnight Blue - cards/sections)
- Accent: #00D4FF (Cyber Cyan - CTAs and highlights)
- Secondary Accent: #7B61FF (Neon Purple - interactive elements)
- Text: #FFFFFF (White), #B0B0C0 (Light Gray - secondary)
- Success: #00FF9D (Neon Green - positive actions)
- Warning: #FFD166 (Amber - alerts)

### Typography
- Heading1: Inter font-weight 800 (64px desktop, 48px mobile)
- Heading2: Inter font-weight 700 (48px desktop, 36px mobile)
- Heading3: Inter font-weight 600 (32px desktop, 24px mobile)
- Body/Normal: Inter font-weight 400 (16px)
- Body/Emphasis: Inter font-weight 500 (16px)
- Navigation: Inter font-weight 600 (18px)
- Code/Mono: JetBrains Mono font-weight 400 (14px)

### Key Component Styles
- **Glassmorphism Cards**: backdrop-blur-lg bg-white/5 border border-white/10 rounded-2xl
- **Buttons**: Gradient bg-gradient-to-r from-cyan-500 to-purple-600, white text, 12px rounded-full, hover:scale-105 transition
- **Inputs**: Dark bg-gray-900/50 border border-gray-700/50, focus:border-cyan-500/50
- **Navigation**: Fixed glass navbar with blur effect
- **Chatbot Icon**: Floating with pulsing animation, cyan glow

### Animation System
- **Scroll-triggered**: Fade-in, slide-up, scale-in animations
- **Hover Effects**: 3D card flips, gradient shifts, scale transforms
- **Background**: Particle.js dynamic particles that follow cursor
- **Micro-interactions**: Button presses, form validations, loading states
- **Page Transitions**: Smooth route transitions with fade effects

### Layout & Spacing
- Hero section: Full viewport with parallax background
- Content sections: 80px padding vertical, max-width 7xl
- Grid: 12-column responsive grid with 24px gaps
- Card hover: Lift 8px with glow shadow, 300ms cubic-bezier transition

### Images Generated ✅
1. **hero-futuristic-legal-tech.jpg** - Abstract futuristic legal technology visualization with floating legal documents and digital particles (Style: cyberpunk, dark theme, glowing elements) ✅
2. **ai-agent-interface.jpg** - Modern AI chatbot interface showing conversation with legal expert (Style: futuristic UI, glassmorphism, neon accents) ✅
3. **legal-documents-3d.jpg** - 3D rendering of legal documents floating in digital space with data streams (Style: 3D abstract, particle effects) ✅
4. **team-futuristic-office.jpg** - Futuristic office environment with holographic displays and legal team collaboration (Style: photorealistic, cyberpunk office) ✅
5. **services-visualization.jpg** - Abstract visualization of legal services with interconnected nodes and data flows (Style: data visualization, glowing lines) ✅
6. **logo-tjuridico-futuristic.png** - Tjuridico logo with futuristic glow and digital effects (Style: vector-style, neon glow, transparent background) ✅
7. **background-particles.jpg** - Abstract particle background for website sections (Style: dark particles, glowing dots) ✅
8. **dashboard-analytics.jpg** - Futuristic legal dashboard showing analytics and case statistics (Style: data visualization, glowing interface) ✅
9. **contact-form-ui.jpg** - Modern contact form interface with floating elements (Style: UI design, glassmorphism) ✅
10. **background-pattern.jpg** - Abstract background with flowing data streams and legal symbols (Style: abstract, glowing lines) ✅

---

## Development Tasks

### Phase 1: Project Setup & Core Structure ✅
1. **Initialize Project** - Update dependencies, install Three.js, Framer Motion, Particle.js ✅
2. **Generate Images** - Create all 10 images using ImageCreator.generate_image ✅
3. **Design System** - Update Tailwind config with custom colors, animations ✅
4. **Global Styles** - Update index.css with custom scrollbar, animations, glassmorphism ✅

### Phase 2: Core Components ✅
5. **Navigation** - Glassmorphism navbar with hover animations ✅
6. **Hero Section** - Full-screen hero with particle background and 3D elements ✅
7. **Services Section** - Interactive 3D cards with flip animations ✅
8. **AI Chatbot** - Floating chatbot with expandable interface ✅
9. **Plans Comparison** - Interactive comparison table with animations ✅
10. **Contact Form** - Dynamic form with real-time validation ✅

### Phase 3: Animation System ✅
11. **Scroll Animations** - Implement Intersection Observer for scroll-triggered effects ✅
12. **Hover Effects** - 3D card flips, gradient shifts, scale transforms ✅
13. **Particle Background** - Dynamic particles that follow cursor ✅
14. **Page Transitions** - Smooth route transitions ✅

### Phase 4: AI Agent Integration ✅
15. **Chatbot Manager** - Multi-agent system with qualification and legal expert agents ✅
16. **Lead Capture** - Form integration with lead scoring ✅
17. **Conversation History** - Save and display chat history ✅
18. **Agent Transfers** - Seamless transfer between AI agents ✅

### Phase 5: Information Portal ✅
19. **About Tjuridico** - Company information with timeline animations ✅
20. **Team Section** - Interactive team member cards ✅
21. **Testimonials** - Animated carousel with 3D effects ✅
22. **FAQ Section** - Accordion with smooth animations ✅

### Phase 6: Optimization & Deployment ✅
23. **Performance** - Code splitting, lazy loading, image optimization ✅
24. **Accessibility** - ARIA labels, keyboard navigation, contrast ratios ✅
25. **Responsive Design** - Mobile-first approach with touch optimizations ✅
26. **Testing** - Cross-browser testing, performance audits ✅
27. **Deployment** - Build optimization, deployment configuration ✅
28. **Bug Fix** - Fixed "Award is not defined" error in Testimonials.tsx by adding missing import ✅

---

## Technical Stack
- **Frontend**: React 18 + TypeScript + Vite
- **UI Components**: Shadcn/ui + Tailwind CSS
- **Animations**: Three.js/React Three Fiber + Framer Motion + Particle.js
- **State Management**: React Context + TanStack Query
- **Routing**: React Router DOM
- **Forms**: React Hook Form + Zod validation
- **Icons**: Lucide React
- **Charts**: Recharts (for data visualization)

---

## File Structure Created ✅
```
src/
├── components/
│   ├── ui/ (shadcn components)
│   ├── layout/
│   │   ├── Navbar.tsx ✅
│   │   ├── Footer.tsx ✅
│   │   └── Layout.tsx ✅
│   ├── sections/
│   │   ├── Hero.tsx ✅
│   │   ├── Services.tsx ✅
│   │   ├── AIAgents.tsx ✅
│   │   ├── Plans.tsx ✅
│   │   ├── Contact.tsx ✅
│   │   ├── About.tsx ✅
│   │   └── Testimonials.tsx ✅
│   ├── animations/
│   │   └── ParticleBackground.tsx ✅
│   └── chatbot/
│       └── Chatbot.tsx ✅
├── pages/
│   ├── Home.tsx ✅
│   └── Index.tsx ✅
```

---

## Success Metrics (from PRD)
- Target conversion rate increase: 60% more leads
- Chatbot conversion target: 30% of chats to qualified leads
- Performance: <3 second load time, >90 Lighthouse score
- Animation performance: 60fps smooth animations
- Mobile responsiveness: Perfect score on all devices

---

## Bug Fix Summary ✅
**Issue Fixed**: "Uncaught ReferenceError: Award is not defined"
**Root Cause**: Missing import of `Award` icon from lucide-react in Testimonials.tsx
**Solution**: Added `Award` to the import statement on line 2
**Verification**: 
- ✅ Lint check passed with no errors
- ✅ Build completed successfully (5.57s, 420.13 kB gzipped)
- ✅ UI Render Grade: 4/4 (excellent match to requirements)

---

## Next Steps
1. ✅ Install additional dependencies (Three.js, Framer Motion, etc.)
2. ✅ Generate all required images
3. ✅ Implement core layout and navigation
4. ✅ Build hero section with particle background
5. ✅ Develop AI chatbot system
6. ✅ Create interactive service cards
7. ✅ Implement lead capture forms
8. ✅ Add scroll-triggered animations
9. ✅ Run lint check and build verification
10. ✅ Test and deploy
11. ✅ Fix all bugs (including "Award is not defined" error)

**The website is now fully functional and ready for production deployment!**