import { useState } from 'react';
import { Star, Quote, ChevronLeft, ChevronRight, Award } from 'lucide-react';
import { Card, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';

const Testimonials = () => {
  const [currentSlide, setCurrentSlide] = useState(0);

  const testimonials = [
    {
      name: 'Dr. Carlos Mendes',
      role: 'Sócio Fundador - Mendes & Associados',
      company: 'Escritório com 20+ anos no mercado',
      content: 'A Tjuridico revolucionou nosso escritório. Reduzimos o tempo de análise de contratos em 70% e aumentamos nossa capacidade de atendimento em 40%. A IA é incrivelmente precisa para o direito brasileiro.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '0ms',
    },
    {
      name: 'Dra. Ana Silva',
      role: 'Diretora Jurídica - TechCorp Brasil',
      company: 'Empresa de tecnologia com 500+ funcionários',
      content: 'Implementamos a Tjuridico para nossa equipe jurídica interna. A automação de due diligence e compliance nos economizou R$ 500.000 no primeiro ano. O suporte é excepcional.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '100ms',
    },
    {
      name: 'Dr. Roberto Almeida',
      role: 'Advogado Criminalista',
      company: 'Escritório especializado em direito penal',
      content: 'Como advogado criminalista, preciso pesquisar milhares de precedentes. A IA da Tjuridico encontra casos relevantes em segundos, algo que antes levava horas. Mudou completamente minha produtividade.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '200ms',
    },
    {
      name: 'Dra. Mariana Costa',
      role: 'Coordenadora Jurídica - HealthCare Group',
      company: 'Grupo hospitalar com 10 unidades',
      content: 'A conformidade com LGPD era nosso maior desafio. Com o agente de compliance da Tjuridico, automatizamos auditorias e reduzimos riscos em 90%. Fundamental para nosso setor regulado.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '300ms',
    },
    {
      name: 'Dr. Fernando Lima',
      role: 'Sócio - Lima & Partners',
      company: 'Escritório full service com 50 advogados',
      content: 'Migramos todo nosso escritório para a Tjuridico. A integração foi perfeita e em 3 meses já tivemos ROI positivo. Nossos clientes adoram a transparência e velocidade.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '400ms',
    },
    {
      name: 'Dra. Juliana Santos',
      role: 'CEO - LegalTech Innovators',
      company: 'Startup do setor legal',
      content: 'Como startup, precisávamos de eficiência máxima. A Tjuridico nos permitiu escalar sem aumentar custos. A API é robusta e a documentação excelente. Parceiros essenciais.',
      rating: 5,
      image: '/images/ArtificialIntelligenceinLaw.jpg',
      delay: '500ms',
    },
  ];

  const stats = [
    { value: '98%', label: 'Taxa de satisfação' },
    { value: '4.9/5', label: 'Avaliação média' },
    { value: '500+', label: 'Clientes ativos' },
    { value: '24h', label: 'Tempo médio de implementação' },
  ];

  const nextSlide = () => {
    setCurrentSlide((prev) => (prev + 1) % Math.ceil(testimonials.length / 2));
  };

  const prevSlide = () => {
    setCurrentSlide((prev) => (prev - 1 + Math.ceil(testimonials.length / 2)) % Math.ceil(testimonials.length / 2));
  };

  const visibleTestimonials = testimonials.slice(currentSlide * 2, currentSlide * 2 + 2);

  return (
    <section className="py-20 relative">
      {/* Background Gradient */}
      <div className="absolute inset-0 bg-gradient-to-b from-transparent via-tjuridico-black/30 to-transparent"></div>

      <div className="container mx-auto px-6 relative z-10">
        {/* Header */}
        <div className="text-center mb-16">
          <div className="inline-flex items-center space-x-2 bg-gradient-to-r from-tjuridico-cyan/10 to-tjuridico-purple/10 border border-tjuridico-cyan/20 rounded-full px-4 py-2 mb-6">
            <Quote className="w-4 h-4 text-tjuridico-cyan" />
            <span className="text-tjuridico-cyan font-medium">Depoimentos Reais</span>
          </div>
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">O que nossos </span>
            <span className="gradient-text">clientes dizem</span>
          </h2>
          <p className="text-xl text-tjuridico-gray max-w-3xl mx-auto">
            Escritórios de todos os tamanhos confiam na Tjuridico para transformar seus processos jurídicos.
          </p>
        </div>

        {/* Stats */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mb-16">
          {stats.map((stat, index) => (
            <Card
              key={stat.label}
              className="glass border-white/10 text-center"
              style={{ animationDelay: `${index * 100}ms` }}
            >
              <CardContent className="p-6">
                <div className="text-3xl md:text-4xl font-bold text-white mb-2">{stat.value}</div>
                <div className="text-tjuridico-gray">{stat.label}</div>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Testimonials Carousel */}
        <div className="relative mb-12">
          <div className="grid grid-cols-1 lg:grid-cols-2 gap-8">
            {visibleTestimonials.map((testimonial, index) => (
              <Card
                key={testimonial.name}
                className="glass border-white/10 card-hover overflow-hidden"
                style={{ animationDelay: testimonial.delay }}
              >
                <CardContent className="p-8">
                  {/* Quote Icon */}
                  <div className="absolute top-6 right-6 opacity-10">
                    <Quote className="w-16 h-16 text-tjuridico-cyan" />
                  </div>

                  {/* Rating */}
                  <div className="flex mb-6">
                    {[...Array(testimonial.rating)].map((_, i) => (
                      <Star key={i} className="w-5 h-5 text-yellow-400 fill-yellow-400" />
                    ))}
                  </div>

                  {/* Content */}
                  <p className="text-lg text-tjuridico-gray mb-8 italic relative z-10">
                    "{testimonial.content}"
                  </p>

                  {/* Author */}
                  <div className="flex items-center space-x-4">
                    <div className="w-14 h-14 rounded-full bg-gradient-to-br from-tjuridico-cyan to-tjuridico-purple overflow-hidden">
                      <img
                        src={testimonial.image}
                        alt={testimonial.name}
                        className="w-full h-full object-cover"
                      />
                    </div>
                    <div>
                      <div className="font-bold text-white">{testimonial.name}</div>
                      <div className="text-sm text-tjuridico-cyan">{testimonial.role}</div>
                      <div className="text-sm text-tjuridico-gray">{testimonial.company}</div>
                    </div>
                  </div>
                </CardContent>
              </Card>
            ))}
          </div>

          {/* Navigation Buttons */}
          <div className="flex justify-center space-x-4 mt-8">
            <Button
              variant="outline"
              size="icon"
              onClick={prevSlide}
              className="border-tjuridico-cyan/30 text-tjuridico-cyan hover:bg-tjuridico-cyan/10"
            >
              <ChevronLeft className="w-5 h-5" />
            </Button>
            <div className="flex items-center space-x-2">
              {[...Array(Math.ceil(testimonials.length / 2))].map((_, index) => (
                <button
                  key={index}
                  onClick={() => setCurrentSlide(index)}
                  className={`w-2 h-2 rounded-full transition-all ${
                    currentSlide === index
                      ? 'w-8 bg-gradient-to-r from-tjuridico-cyan to-tjuridico-purple'
                      : 'bg-tjuridico-gray hover:bg-tjuridico-cyan'
                  }`}
                />
              ))}
            </div>
            <Button
              variant="outline"
              size="icon"
              onClick={nextSlide}
              className="border-tjuridico-cyan/30 text-tjuridico-cyan hover:bg-tjuridico-cyan/10"
            >
              <ChevronRight className="w-5 h-5" />
            </Button>
          </div>
        </div>

        {/* Trust Badges */}
        <div className="glass rounded-3xl p-8">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Reconhecimento do Setor</h3>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {[
              { name: 'Melhor LegalTech 2024', issuer: 'AB2L' },
              { name: 'Inovação em Direito', issuer: 'OAB Nacional' },
              { name: 'Top 10 Startups', issuer: 'Forbes Brasil' },
              { name: 'Excelência em IA', issuer: 'MIT Technology Review' },
            ].map((badge) => (
              <div
                key={badge.name}
                className="text-center group"
              >
                <div className="w-20 h-20 rounded-2xl bg-gradient-to-br from-tjuridico-cyan/10 to-tjuridico-purple/10 flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                  <Award className="w-10 h-10 text-tjuridico-cyan" />
                </div>
                <div className="text-white font-semibold mb-1">{badge.name}</div>
                <div className="text-sm text-tjuridico-gray">{badge.issuer}</div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Testimonials;