import { FileText, Scale, Users, Search, Clock, Shield } from 'lucide-react';
import { Card, CardContent } from '@/components/ui/card';
import { Button } from '@/components/ui/button';

const Services = () => {
  const services = [
    {
      icon: FileText,
      title: 'Análise de Documentos',
      description: 'IA especializada analisa contratos, petições e documentos legais em segundos.',
      features: ['Revisão automática', 'Identificação de riscos', 'Sugestões de melhorias'],
      color: 'from-tjuridico-cyan to-tjuridico-blue',
      delay: '0ms',
    },
    {
      icon: Scale,
      title: 'Consultoria Jurídica IA',
      description: 'Agentes virtuais especializados em diferentes áreas do direito brasileiro.',
      features: ['Direito Civil', 'Direito Trabalhista', 'Direito Empresarial'],
      color: 'from-tjuridico-purple to-tjuridico-pink',
      delay: '100ms',
    },
    {
      icon: Users,
      title: 'Gestão de Clientes',
      description: 'Sistema inteligente para acompanhamento de casos e comunicação com clientes.',
      features: ['Dashboard interativo', 'Notificações automáticas', 'Relatórios detalhados'],
      color: 'from-tjuridico-green to-tjuridico-cyan',
      delay: '200ms',
    },
    {
      icon: Search,
      title: 'Due Diligence',
      description: 'Análise completa de empresas e indivíduos para processos de M&A.',
      features: ['Análise de background', 'Verificação de compliance', 'Relatórios customizados'],
      color: 'from-tjuridico-blue to-tjuridico-purple',
      delay: '300ms',
    },
    {
      icon: Clock,
      title: 'Automação de Processos',
      description: 'Automatize tarefas repetitivas e aumente a produtividade do seu escritório.',
      features: ['Geração automática', 'Integração com sistemas', 'Workflows personalizados'],
      color: 'from-tjuridico-pink to-tjuridico-green',
      delay: '400ms',
    },
    {
      icon: Shield,
      title: 'Conformidade LGPD',
      description: 'Garanta total conformidade com a Lei Geral de Proteção de Dados.',
      features: ['Auditoria automática', 'Relatórios de compliance', 'Treinamento IA'],
      color: 'from-tjuridico-cyan to-tjuridico-green',
      delay: '500ms',
    },
  ];

  return (
    <section id="services" className="py-20 relative">
      {/* Background Elements */}
      <div className="absolute top-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-tjuridico-cyan to-transparent"></div>
      
      <div className="container mx-auto px-6">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">Nossos </span>
            <span className="gradient-text">Serviços</span>
          </h2>
          <p className="text-xl text-tjuridico-gray max-w-3xl mx-auto">
            Oferecemos soluções completas de inteligência artificial adaptadas às necessidades 
            específicas do setor jurídico brasileiro.
          </p>
        </div>

        {/* Services Grid */}
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
          {services.map((service) => (
            <Card
              key={service.title}
              className="glass card-hover border-white/10 overflow-hidden group relative"
              style={{ animationDelay: service.delay }}
            >
              {/* Gradient Border Effect */}
              <div className="absolute inset-0 bg-gradient-to-br from-transparent via-transparent to-transparent group-hover:via-white/5 transition-all duration-500"></div>
              
              <CardContent className="p-8 relative z-10">
                {/* Icon */}
                <div className={`w-16 h-16 rounded-2xl bg-gradient-to-br ${service.color} flex items-center justify-center mb-6 group-hover:scale-110 transition-transform duration-300`}>
                  <service.icon className="w-8 h-8 text-white" />
                </div>

                {/* Content */}
                <h3 className="text-2xl font-bold text-white mb-4">{service.title}</h3>
                <p className="text-tjuridico-gray mb-6">{service.description}</p>

                {/* Features */}
                <ul className="space-y-3 mb-6">
                  {service.features.map((feature) => (
                    <li key={feature} className="flex items-center text-sm text-tjuridico-gray">
                      <div className="w-1.5 h-1.5 rounded-full bg-tjuridico-cyan mr-3"></div>
                      {feature}
                    </li>
                  ))}
                </ul>

                {/* CTA */}
                <Button
                  variant="ghost"
                  className="w-full border border-white/10 text-tjuridico-gray hover:text-white hover:bg-white/5 group-hover:border-tjuridico-cyan/30 transition-all"
                >
                  Saiba mais
                  <div className="ml-2 w-5 h-5 rounded-full border border-tjuridico-gray group-hover:border-tjuridico-cyan flex items-center justify-center">
                    <div className="w-1.5 h-1.5 rounded-full bg-tjuridico-gray group-hover:bg-tjuridico-cyan"></div>
                  </div>
                </Button>
              </CardContent>

              {/* Hover Effect */}
              <div className="absolute bottom-0 left-0 right-0 h-1 bg-gradient-to-r from-transparent via-tjuridico-cyan to-transparent opacity-0 group-hover:opacity-100 transition-opacity duration-300"></div>
            </Card>
          ))}
        </div>

        {/* Bottom CTA */}
        <div className="mt-16 text-center">
          <div className="inline-flex flex-col sm:flex-row items-center gap-4 glass rounded-2xl p-6">
            <div className="text-left">
              <h3 className="text-xl font-bold text-white mb-2">Precisa de uma solução personalizada?</h3>
              <p className="text-tjuridico-gray">Nossa equipe pode desenvolver um pacote específico para seu escritório.</p>
            </div>
            <Button className="btn-futuristic whitespace-nowrap">
              Fale com um Especialista
            </Button>
          </div>
        </div>
      </div>

      {/* Bottom Gradient */}
      <div className="absolute bottom-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-tjuridico-purple to-transparent"></div>
    </section>
  );
};

export default Services;