import { Check, Star, Zap, Users, Globe, Shield } from 'lucide-react';
import { Card, CardContent, CardDescription, CardFooter, CardHeader, CardTitle } from '@/components/ui/card';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';

const Plans = () => {
  const plans = [
    {
      name: 'Startup',
      description: 'Perfeito para escritórios iniciantes',
      price: 'R$ 299',
      period: '/mês',
      popular: false,
      icon: Zap,
      color: 'from-tjuridico-cyan to-tjuridico-blue',
      features: [
        '1 Agente de IA Legal Assistant',
        'Até 100 documentos/mês',
        'Suporte por e-mail',
        'Dashboard básico',
        'Relatórios mensais',
        'Integração com Google Drive',
      ],
      cta: 'Começar Agora',
      delay: '0ms',
    },
    {
      name: 'Profissional',
      description: 'Ideal para escritórios em crescimento',
      price: 'R$ 699',
      period: '/mês',
      popular: true,
      icon: Users,
      color: 'from-tjuridico-purple to-tjuridico-pink',
      features: [
        '3 Agentes de IA (Legal, Customer, Compliance)',
        'Documentos ilimitados',
        'Suporte prioritário 24/7',
        'Dashboard avançado',
        'Relatórios personalizados',
        'API de integração',
        'Treinamento da equipe',
        'LGPD compliance',
      ],
      cta: 'Escolher Plano',
      delay: '100ms',
    },
    {
      name: 'Enterprise',
      description: 'Solução completa para grandes escritórios',
      price: 'Personalizado',
      period: '',
      popular: false,
      icon: Globe,
      color: 'from-tjuridico-green to-tjuridico-cyan',
      features: [
        'Agentes de IA ilimitados',
        'Documentos ilimitados',
        'Suporte dedicado 24/7',
        'Dashboard empresarial',
        'Relatórios em tempo real',
        'API premium',
        'Treinamento personalizado',
        'Consultoria especializada',
        'SLA 99.9%',
        'Integração com sistemas legados',
      ],
      cta: 'Falar com Vendas',
      delay: '200ms',
    },
  ];

  const features = [
    {
      icon: Shield,
      title: 'Segurança de Dados',
      description: 'Criptografia de ponta a ponta e compliance total com LGPD',
    },
    {
      icon: Zap,
      title: 'Implementação Rápida',
      description: 'Configure sua conta e comece a usar em menos de 24 horas',
    },
    {
      icon: Users,
      title: 'Suporte Especializado',
      description: 'Equipe técnica dedicada ao setor jurídico brasileiro',
    },
    {
      icon: Check,
      title: 'Garantia de Satisfação',
      description: '14 dias grátis para testar sem compromisso',
    },
  ];

  return (
    <section id="plans" className="py-20 relative">
      {/* Background Gradient */}
      <div className="absolute inset-0 bg-gradient-to-b from-transparent via-tjuridico-black/50 to-transparent"></div>

      <div className="container mx-auto px-6 relative z-10">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">Planos que </span>
            <span className="gradient-text">crescem com você</span>
          </h2>
          <p className="text-xl text-tjuridico-gray max-w-3xl mx-auto">
            Escolha o plano ideal para o seu escritório. Todos incluem nossa tecnologia de ponta 
            e suporte especializado.
          </p>
        </div>

        {/* Plans Grid */}
        <div className="grid grid-cols-1 md:grid-cols-3 gap-8 mb-16">
          {plans.map((plan) => (
            <Card
              key={plan.name}
              className={`glass border-white/10 overflow-hidden relative group ${
                plan.popular ? 'border-tjuridico-purple/50 shadow-[0_0_40px_rgba(147,51,234,0.3)]' : ''
              }`}
              style={{ animationDelay: plan.delay }}
            >
              {plan.popular && (
                <div className="absolute top-0 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                  <Badge className="bg-gradient-to-r from-tjuridico-purple to-tjuridico-pink text-white px-4 py-1 rounded-full">
                    <Star className="w-3 h-3 mr-1" />
                    Mais Popular
                  </Badge>
                </div>
              )}

              <CardHeader className="pb-6">
                <div className="flex items-center justify-between mb-4">
                  <div className={`w-12 h-12 rounded-xl bg-gradient-to-br ${plan.color} flex items-center justify-center`}>
                    <plan.icon className="w-6 h-6 text-white" />
                  </div>
                  {plan.popular && (
                    <div className="text-sm font-medium text-tjuridico-purple">Economize 30%</div>
                  )}
                </div>
                <CardTitle className="text-2xl font-bold text-white">{plan.name}</CardTitle>
                <CardDescription className="text-tjuridico-gray">{plan.description}</CardDescription>
              </CardHeader>

              <CardContent>
                {/* Price */}
                <div className="mb-6">
                  <div className="flex items-baseline">
                    <span className="text-4xl font-bold text-white">{plan.price}</span>
                    <span className="text-tjuridico-gray ml-2">{plan.period}</span>
                  </div>
                  <div className="text-sm text-tjuridico-gray mt-2">Cobrança mensal • Sem contrato mínimo</div>
                </div>

                {/* Features */}
                <ul className="space-y-3 mb-6">
                  {plan.features.map((feature, index) => (
                    <li key={index} className="flex items-start">
                      <Check className="w-5 h-5 text-tjuridico-green mr-3 flex-shrink-0 mt-0.5" />
                      <span className="text-tjuridico-gray">{feature}</span>
                    </li>
                  ))}
                </ul>
              </CardContent>

              <CardFooter>
                <Button
                  className={`w-full ${
                    plan.popular
                      ? 'btn-futuristic'
                      : 'bg-white/10 hover:bg-white/20 text-white border border-white/20'
                  }`}
                >
                  {plan.cta}
                </Button>
              </CardFooter>

              {/* Hover Effect */}
              <div className="absolute inset-0 bg-gradient-to-br from-transparent via-transparent to-transparent group-hover:via-white/5 transition-all duration-500 pointer-events-none"></div>
            </Card>
          ))}
        </div>

        {/* Features Comparison */}
        <div className="glass rounded-3xl p-8">
          <div className="text-center mb-8">
            <h3 className="text-2xl font-bold text-white mb-4">Todos os planos incluem</h3>
            <p className="text-tjuridico-gray">Recursos essenciais para transformar seu escritório</p>
          </div>

          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {features.map((feature, index) => (
              <div
                key={feature.title}
                className="text-center group"
                style={{ animationDelay: `${index * 100}ms` }}
              >
                <div className="w-16 h-16 rounded-2xl bg-gradient-to-br from-tjuridico-cyan/10 to-tjuridico-purple/10 flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                  <feature.icon className="w-8 h-8 text-tjuridico-cyan" />
                </div>
                <h4 className="text-lg font-bold text-white mb-2">{feature.title}</h4>
                <p className="text-sm text-tjuridico-gray">{feature.description}</p>
              </div>
            ))}
          </div>
        </div>

        {/* FAQ Section */}
        <div className="mt-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Perguntas Frequentes</h3>
          <div className="grid grid-cols-1 md:grid-cols-2 gap-6">
            {[
              {
                question: 'Posso cancelar a qualquer momento?',
                answer: 'Sim, não há contrato mínimo. Você pode cancelar quando quiser sem multas.',
              },
              {
                question: 'Como funciona o período de teste gratuito?',
                answer: '14 dias com acesso completo a todos os recursos do plano escolhido.',
              },
              {
                question: 'Meus dados estão seguros?',
                answer: 'Sim, usamos criptografia de ponta a ponta e somos totalmente compliant com LGPD.',
              },
              {
                question: 'Preciso de treinamento para usar?',
                answer: 'Não, nossa interface é intuitiva. Oferecemos treinamento gratuito se necessário.',
              },
            ].map((faq, index) => (
              <div
                key={index}
                className="glass rounded-xl p-6 border border-white/10 hover:border-tjuridico-cyan/30 transition-colors"
              >
                <h4 className="text-lg font-bold text-white mb-2">{faq.question}</h4>
                <p className="text-tjuridico-gray">{faq.answer}</p>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default Plans;