import { Target, Users, Globe, Award } from 'lucide-react';
import { Card, CardContent } from '@/components/ui/card';

const About = () => {
  const values = [
    {
      icon: Target,
      title: 'Missão',
      description: 'Democratizar o acesso à tecnologia jurídica de ponta, tornando os serviços legais mais eficientes, acessíveis e transparentes para todos.',
      color: 'text-tjuridico-cyan',
      bgColor: 'bg-tjuridico-cyan/10',
    },
    {
      icon: Users,
      title: 'Visão',
      description: 'Ser a principal plataforma de inteligência artificial para o setor jurídico brasileiro, transformando a maneira como escritórios operam e servem seus clientes.',
      color: 'text-tjuridico-purple',
      bgColor: 'bg-tjuridico-purple/10',
    },
    {
      icon: Globe,
      title: 'Impacto',
      description: 'Reduzir em até 60% o tempo gasto em tarefas repetitivas, permitindo que advogados foquem no que realmente importa: a estratégia e o relacionamento com clientes.',
      color: 'text-tjuridico-green',
      bgColor: 'bg-tjuridico-green/10',
    },
    {
      icon: Award,
      title: 'Excelência',
      description: 'Manter os mais altos padrões de qualidade, segurança e inovação, sempre em compliance com as regulamentações brasileiras.',
      color: 'text-tjuridico-pink',
      bgColor: 'bg-tjuridico-pink/10',
    },
  ];

  const milestones = [
    { year: '2023', event: 'Fundação da Tjuridico' },
    { year: '2024', event: 'Lançamento da primeira versão da plataforma' },
    { year: '2025', event: 'Expansão para 5 estados brasileiros' },
    { year: '2026', event: 'Meta: Atender 1000+ escritórios' },
  ];

  return (
    <section id="about" className="py-20 relative">
      {/* Background Pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute inset-0" style={{
          backgroundImage: `url("https://mgx-backend-cdn.metadl.com/generate/images/877184/2026-01-01/dafffe65-b182-4c66-b32a-b3b591a02f91.png")`,
          backgroundSize: 'cover',
          backgroundPosition: 'center',
        }}></div>
      </div>

      <div className="container mx-auto px-6 relative z-10">
        {/* Header */}
        <div className="text-center mb-16">
          <h2 className="text-4xl md:text-5xl font-bold mb-6">
            <span className="text-white">Sobre a </span>
            <span className="gradient-text">Tjuridico</span>
          </h2>
          <p className="text-xl text-tjuridico-gray max-w-3xl mx-auto">
            Somos uma startup brasileira dedicada a revolucionar o setor jurídico através da 
            inteligência artificial e tecnologia de ponta.
          </p>
        </div>

        <div className="grid grid-cols-1 lg:grid-cols-2 gap-12 mb-16">
          {/* Left Column - Story */}
          <div>
            <div className="glass rounded-3xl p-8 mb-8">
              <h3 className="text-2xl font-bold text-white mb-6">Nossa História</h3>
              <div className="space-y-4 text-tjuridico-gray">
                <p>
                  Fundada em 2023 por um grupo de advogados e engenheiros de software, a Tjuridico nasceu 
                  da necessidade de modernizar um setor tradicional que ainda dependia fortemente de 
                  processos manuais e burocráticos.
                </p>
                <p>
                  Percebemos que advogados gastavam mais de 60% do seu tempo em tarefas repetitivas como 
                  análise de documentos, pesquisa de jurisprudência e preenchimento de formulários. 
                  Isso limitava sua capacidade de focar no que realmente importa: a estratégia jurídica 
                  e o relacionamento com clientes.
                </p>
                <p>
                  Combinando nossa expertise jurídica com tecnologia de ponta em inteligência artificial, 
                  desenvolvemos uma plataforma que automatiza essas tarefas, aumentando a eficiência em 
                  até 60% e reduzindo custos operacionais significativamente.
                </p>
              </div>
            </div>

            {/* Team Stats */}
            <div className="grid grid-cols-2 gap-4">
              <Card className="glass border-white/10">
                <CardContent className="p-6 text-center">
                  <div className="text-3xl font-bold text-white mb-2">50+</div>
                  <div className="text-tjuridico-gray">Especialistas</div>
                </CardContent>
              </Card>
              <Card className="glass border-white/10">
                <CardContent className="p-6 text-center">
                  <div className="text-3xl font-bold text-white mb-2">24/7</div>
                  <div className="text-tjuridico-gray">Operação</div>
                </CardContent>
              </Card>
            </div>
          </div>

          {/* Right Column - Values */}
          <div>
            <h3 className="text-2xl font-bold text-white mb-8">Nossos Valores</h3>
            <div className="space-y-6">
              {values.map((value, index) => (
                <Card
                  key={value.title}
                  className="glass border-white/10 card-hover"
                  style={{ animationDelay: `${index * 100}ms` }}
                >
                  <CardContent className="p-6">
                    <div className="flex items-start space-x-4">
                      <div className={`w-12 h-12 rounded-xl ${value.bgColor} flex items-center justify-center flex-shrink-0`}>
                        <value.icon className={`w-6 h-6 ${value.color}`} />
                      </div>
                      <div>
                        <h4 className="text-lg font-bold text-white mb-2">{value.title}</h4>
                        <p className="text-tjuridico-gray">{value.description}</p>
                      </div>
                    </div>
                  </CardContent>
                </Card>
              ))}
            </div>
          </div>
        </div>

        {/* Timeline */}
        <div className="mb-16">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Nossa Jornada</h3>
          <div className="relative">
            {/* Timeline Line */}
            <div className="absolute left-1/2 transform -translate-x-1/2 h-full w-px bg-gradient-to-b from-tjuridico-cyan via-tjuridico-purple to-tjuridico-green"></div>
            
            {/* Milestones */}
            <div className="space-y-12">
              {milestones.map((milestone, index) => (
                <div
                  key={milestone.year}
                  className={`flex items-center ${index % 2 === 0 ? 'flex-row' : 'flex-row-reverse'}`}
                >
                  <div className={`w-1/2 ${index % 2 === 0 ? 'pr-12 text-right' : 'pl-12'}`}>
                    <div className="glass rounded-xl p-6 inline-block max-w-md">
                      <div className="text-sm font-medium text-tjuridico-cyan mb-1">{milestone.year}</div>
                      <div className="text-white font-semibold">{milestone.event}</div>
                    </div>
                  </div>
                  <div className="w-8 h-8 rounded-full bg-gradient-to-br from-tjuridico-cyan to-tjuridico-purple border-4 border-tjuridico-black flex items-center justify-center relative z-10"></div>
                  <div className="w-1/2"></div>
                </div>
              ))}
            </div>
          </div>
        </div>

        {/* Partners */}
        <div className="glass rounded-3xl p-8">
          <h3 className="text-2xl font-bold text-white text-center mb-8">Parceiros e Reconhecimentos</h3>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-8">
            {[
              { name: 'OAB-SP', logo: 'OAB' },
              { name: 'Startup Brasil', logo: 'GovBR' },
              { name: 'LegalTech Awards', logo: 'LTA' },
              { name: 'Google for Startups', logo: 'Google' },
            ].map((partner) => (
              <div
                key={partner.name}
                className="text-center group"
              >
                <div className="w-20 h-20 rounded-2xl bg-gradient-to-br from-tjuridico-cyan/10 to-tjuridico-purple/10 flex items-center justify-center mx-auto mb-4 group-hover:scale-110 transition-transform duration-300">
                  <div className="text-xl font-bold text-white">{partner.logo}</div>
                </div>
                <div className="text-tjuridico-gray">{partner.name}</div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
};

export default About;