import { Facebook, Twitter, Linkedin, Instagram, Mail, Phone, MapPin } from 'lucide-react';
import { Button } from '@/components/ui/button';
import { Input } from '@/components/ui/input';

const Footer = () => {
  const currentYear = new Date().getFullYear();

  const footerLinks = {
    Serviços: [
      { label: 'Consultoria Jurídica', href: '#' },
      { label: 'Contratos Inteligentes', href: '#' },
      { label: 'Análise de Documentos', href: '#' },
      { label: 'Due Diligence', href: '#' },
    ],
    Empresa: [
      { label: 'Sobre Nós', href: '#' },
      { label: 'Equipe', href: '#' },
      { label: 'Carreiras', href: '#' },
      { label: 'Blog', href: '#' },
    ],
    Recursos: [
      { label: 'Agentes IA', href: '#' },
      { label: 'API', href: '#' },
      { label: 'Documentação', href: '#' },
      { label: 'Status', href: '#' },
    ],
    Legal: [
      { label: 'Termos de Uso', href: '#' },
      { label: 'Política de Privacidade', href: '#' },
      { label: 'Cookies', href: '#' },
      { label: 'LGPD', href: '#' },
    ],
  };

  const socialLinks = [
    { icon: Facebook, label: 'Facebook', href: '#' },
    { icon: Twitter, label: 'Twitter', href: '#' },
    { icon: Linkedin, label: 'LinkedIn', href: '#' },
    { icon: Instagram, label: 'Instagram', href: '#' },
  ];

  return (
    <footer className="relative overflow-hidden bg-tjuridico-midnight-blue border-t border-white/10">
      {/* Background pattern */}
      <div className="absolute inset-0 opacity-5">
        <div className="absolute inset-0" style={{
          backgroundImage: `url("https://mgx-backend-cdn.metadl.com/generate/images/877184/2026-01-01/dafffe65-b182-4c66-b32a-b3b591a02f91.png")`,
          backgroundSize: 'cover',
          backgroundPosition: 'center',
        }}></div>
      </div>

      <div className="container mx-auto px-6 py-16 relative z-10">
        <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-5 gap-12">
          {/* Brand Column */}
          <div className="lg:col-span-2">
            <div className="flex items-center space-x-3 mb-6">
              <div className="w-12 h-12 bg-gradient-to-br from-tjuridico-cyan to-tjuridico-purple rounded-xl flex items-center justify-center">
                <span className="text-white font-bold text-xl">TJ</span>
              </div>
              <div className="flex flex-col">
                <span className="text-2xl font-bold bg-gradient-to-r from-tjuridico-cyan to-tjuridico-purple bg-clip-text text-transparent">
                  Tjuridico
                </span>
                <span className="text-sm text-tjuridico-gray">.com.br</span>
              </div>
            </div>
            <p className="text-tjuridico-gray mb-8 max-w-md">
              Revolucionando o setor jurídico com inteligência artificial. Oferecemos soluções inovadoras 
              para otimizar processos, reduzir custos e aumentar a eficiência legal.
            </p>
            
            {/* Newsletter */}
            <div className="space-y-4">
              <h3 className="text-white font-semibold">Inscreva-se na nossa newsletter</h3>
              <div className="flex space-x-2">
                <Input
                  type="email"
                  placeholder="Seu e-mail"
                  className="bg-white/5 border-white/10 text-white placeholder:text-tjuridico-gray focus:border-tjuridico-cyan"
                />
                <Button className="btn-futuristic whitespace-nowrap">
                  Inscrever
                </Button>
              </div>
            </div>
          </div>

          {/* Links Columns */}
          {Object.entries(footerLinks).map(([category, links]) => (
            <div key={category}>
              <h3 className="text-white font-semibold mb-6 text-lg">{category}</h3>
              <ul className="space-y-3">
                {links.map((link) => (
                  <li key={link.label}>
                    <a
                      href={link.href}
                      className="text-tjuridico-gray hover:text-tjuridico-cyan transition-colors duration-300 flex items-center group"
                    >
                      <span className="w-0 h-0.5 bg-tjuridico-cyan transition-all duration-300 group-hover:w-3 mr-2"></span>
                      {link.label}
                    </a>
                  </li>
                ))}
              </ul>
            </div>
          ))}
        </div>

        {/* Contact Info */}
        <div className="mt-16 pt-8 border-t border-white/10">
          <div className="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-tjuridico-cyan/10 rounded-lg flex items-center justify-center">
                <MapPin className="w-5 h-5 text-tjuridico-cyan" />
              </div>
              <div>
                <p className="text-tjuridico-gray text-sm">Endereço</p>
                <p className="text-white">Av. Paulista, 1000 - São Paulo, SP</p>
              </div>
            </div>
            <div className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-tjuridico-purple/10 rounded-lg flex items-center justify-center">
                <Phone className="w-5 h-5 text-tjuridico-purple" />
              </div>
              <div>
                <p className="text-tjuridico-gray text-sm">Telefone</p>
                <p className="text-white">(11) 99999-9999</p>
              </div>
            </div>
            <div className="flex items-center space-x-3">
              <div className="w-10 h-10 bg-tjuridico-green/10 rounded-lg flex items-center justify-center">
                <Mail className="w-5 h-5 text-tjuridico-green" />
              </div>
              <div>
                <p className="text-tjuridico-gray text-sm">E-mail</p>
                <p className="text-white">contato@tjuridico.com.br</p>
              </div>
            </div>
          </div>
        </div>

        {/* Bottom Bar */}
        <div className="mt-12 pt-8 border-t border-white/10">
          <div className="flex flex-col md:flex-row justify-between items-center space-y-6 md:space-y-0">
            <div className="text-tjuridico-gray text-sm">
              © {currentYear} Tjuridico.com.br. Todos os direitos reservados.
            </div>
            
            <div className="flex items-center space-x-6">
              {/* Social Links */}
              <div className="flex items-center space-x-4">
                {socialLinks.map((social) => (
                  <a
                    key={social.label}
                    href={social.href}
                    className="w-10 h-10 rounded-full bg-white/5 flex items-center justify-center text-tjuridico-gray hover:text-tjuridico-cyan hover:bg-tjuridico-cyan/10 transition-all duration-300"
                    aria-label={social.label}
                  >
                    <social.icon className="w-5 h-5" />
                  </a>
                ))}
              </div>
              
              {/* Language Selector */}
              <div className="flex items-center space-x-2">
                <div className="w-6 h-4 bg-gradient-to-r from-tjuridico-cyan to-tjuridico-purple rounded"></div>
                <span className="text-white">Português (BR)</span>
              </div>
            </div>
          </div>
        </div>
      </div>

      {/* Floating particles effect */}
      <div className="absolute bottom-0 left-0 right-0 h-px bg-gradient-to-r from-transparent via-tjuridico-cyan to-transparent"></div>
    </footer>
  );
};

export default Footer;