# Estrutura de Arquivos do Projeto

## Visão Geral
```
tjuridico-website/
├── frontend/                 # Aplicação React/TypeScript
├── backend/                  # API FastAPI
├── shared/                   # Código compartilhado
├── infrastructure/           # Configuração de infraestrutura
├── docs/                     # Documentação
└── scripts/                  # Scripts utilitários
```

## Frontend (`/frontend`)
```
frontend/
├── public/                   # Assets públicos
│   ├── favicon.ico
│   ├── robots.txt
│   ├── manifest.json
│   └── images/              # Imagens otimizadas
│       ├── hero/
│       ├── icons/
│       └── 3d-models/
├── src/
│   ├── index.tsx            # Ponto de entrada
│   ├── App.tsx              # Componente raiz
│   ├── styles/              # Estilos globais
│   │   ├── globals.css
│   │   ├── animations.css
│   │   └── theme.css
│   ├── components/          # Componentes React
│   │   ├── ui/              # Componentes base (Shadcn)
│   │   │   ├── button/
│   │   │   ├── card/
│   │   │   ├── dialog/
│   │   │   └── ...
│   │   ├── layout/          # Componentes de layout
│   │   │   ├── Header/
│   │   │   ├── Footer/
│   │   │   ├── Navigation/
│   │   │   └── Sidebar/
│   │   ├── sections/        # Seções da página
│   │   │   ├── HeroSection/
│   │   │   ├── ServicesSection/
│   │   │   ├── PlansSection/
│   │   │   ├── HowItWorks/
│   │   │   └── Testimonials/
│   │   ├── animations/      # Componentes de animação
│   │   │   ├── ParticleBackground/
│   │   │   ├── ScrollTrigger/
│   │   │   ├── ThreeJSModel/
│   │   │   └── HoverEffects/
│   │   └── chatbot/         # Sistema de chatbot
│   │       ├── ChatWidget/
│   │       ├── MessageBubble/
│   │       ├── ChatInput/
│   │       └── AgentSelector/
│   ├── hooks/               # Custom hooks
│   │   ├── useAnimation.ts
│   │   ├── useChat.ts
│   │   ├── useScroll.ts
│   │   └── useThreeJS.ts
│   ├── services/            # Serviços de API
│   │   ├── api/
│   │   │   ├── client.ts
│   │   │   ├── chat.ts
│   │   │   ├── leads.ts
│   │   │   └── analytics.ts
│   │   └── websocket/       # Conexão WebSocket
│   ├── utils/               # Utilitários
│   │   ├── animationUtils.ts
│   │   ├── validation.ts
│   │   ├── formatters.ts
│   │   └── constants.ts
│   ├── types/               # Tipos TypeScript
│   │   ├── animation.ts
│   │   ├── chat.ts
│   │   ├── lead.ts
│   │   └── api.ts
│   ├── pages/               # Páginas da aplicação
│   │   ├── HomePage.tsx
│   │   ├── ServicesPage.tsx
│   │   ├── PlansPage.tsx
│   │   ├── ContactPage.tsx
│   │   └── AboutPage.tsx
│   └── store/               # Gerenciamento de estado
│       ├── slices/
│       │   ├── chatSlice.ts
│       │   ├── leadSlice.ts
│       │   └── uiSlice.ts
│       └── index.ts
├── package.json
├── tsconfig.json
├── tailwind.config.js
├── postcss.config.js
├── vite.config.ts          # Vite como bundler
└── README.md
```

## Backend (`/backend`)
```
backend/
├── src/
│   ├── main.py             # Ponto de entrada FastAPI
│   ├── config/             # Configurações
│   │   ├── settings.py
│   │   ├── database.py
│   │   └── security.py
│   ├── api/                # Rotas da API
│   │   ├── v1/             # Versão 1 da API
│   │   │   ├── __init__.py
│   │   │   ├── endpoints/
│   │   │   │   ├── chat.py
│   │   │   │   ├── leads.py
│   │   │   │   ├── analytics.py
│   │   │   │   └── webhooks.py
│   │   │   └── routers.py
│   │   └── dependencies.py # Dependências FastAPI
│   ├── core/               # Lógica de negócio
│   │   ├── security.py     # Autenticação/autorização
│   │   └── exceptions.py   # Exceções customizadas
│   ├── models/             # Modelos SQLModel
│   │   ├── base.py         # Modelo base
│   │   ├── lead.py         # Modelo de lead
│   │   ├── chat.py         # Modelos de chat
│   │   ├── ai_agent.py     # Modelos de agentes
│   │   └── enums.py        # Enums do sistema
│   ├── schemas/            # Schemas Pydantic
│   │   ├── lead.py
│   │   ├── chat.py
│   │   ├── ai_agent.py
│   │   └── response.py
│   ├── services/           # Serviços de negócio
│   │   ├── lead_service.py
│   │   ├── chat_service.py
│   │   ├── ai_agent_service.py
│   │   ├── analytics_service.py
│   │   └── notification_service.py
│   ├── agents/             # Implementação dos agentes de IA
│   │   ├── base_agent.py   # Classe base do agente
│   │   ├── qualification_agent.py
│   │   ├── legal_expert_agent.py
│   │   ├── prospecting_agent.py
│   │   └── status_agent.py
│   ├── llm/                # Integração com LLMs
│   │   ├── client.py       # Cliente LLM
│   │   ├── prompts/        # Templates de prompt
│   │   │   ├── qualification_prompts.py
│   │   │   ├── legal_prompts.py
│   │   │   └── general_prompts.py
│   │   └── knowledge_base/ # Base de conhecimento
│   │       ├── legal_documents/
│   │       ├── faqs/
│   │       └── procedures/
│   ├── database/           # Configuração do banco
│   │   ├── session.py      # Sessão do banco
│   │   ├── migrations/     # Migrações Alembic
│   │   └── seed/           # Dados iniciais
│   ├── integrations/       # Integrações externas
│   │   ├── whatsapp/
│   │   ├── google_analytics/
│   │   └── crm/
│   └── utils/              # Utilitários
│       ├── validators.py
│       ├── formatters.py
│       └── helpers.py
├── tests/                  # Testes
│   ├── unit/
│   ├── integration/
│   └── fixtures/
├── alembic.ini             # Configuração Alembic
├── requirements.txt        # Dependências Python
├── Dockerfile
└── README.md
```

## Shared (`/shared`)
```
shared/
├── types/                  # Tipos compartilhados TypeScript/Python
│   ├── chat.types.ts
│   ├── lead.types.ts
│   └── api.types.ts
└── schemas/               # Schemas compartilhados (JSON Schema)
    ├── chat.schema.json
    ├── lead.schema.json
    └── animation.schema.json
```

## Infrastructure (`/infrastructure`)
```
infrastructure/
├── docker/                 # Configuração Docker
│   ├── frontend.Dockerfile
│   ├── backend.Dockerfile
│   ├── nginx.Dockerfile
│   └── docker-compose.yml
├── nginx/                  # Configuração Nginx
│   ├── nginx.conf
│   └── sites-available/
├── monitoring/             # Monitoramento
│   ├── prometheus/
│   ├── grafana/
│   └── alerts/
├── ci-cd/                  # Pipeline CI/CD
│   ├── github-actions/
│   └── gitlab-ci.yml
└── terraform/              # Infra como código (opcional)
    ├── main.tf
    ├── variables.tf
    └── outputs.tf
```

## Documentação (`/docs`)
```
docs/
├── api/                    # Documentação da API
│   ├── openapi.yaml
│   └── postman_collection.json
├── architecture/           # Documentação de arquitetura
│   ├── system_design.md
│   ├── diagrams/          # Diagramas PlantUML
│   │   ├── architect.puml
│   │   ├── class_diagram.puml
│   │   ├── sequence_diagram.puml
│   │   └── er_diagram.puml
│   └── decisions/         # ADRs (Architecture Decision Records)
├── user-guides/           # Guias de usuário
│   ├── admin-guide.md
│   ├── user-guide.md
│   └── chatbot-guide.md
└── development/           # Guias de desenvolvimento
    ├── setup.md
    ├── coding-standards.md
    └── testing-guide.md
```

## Scripts (`/scripts`)
```
scripts/
├── dev/                    # Scripts de desenvolvimento
│   ├── start-dev.sh
│   ├── setup-db.sh
│   └── seed-data.sh
├── deployment/             # Scripts de deploy
│   ├── build.sh
│   ├── deploy.sh
│   └── rollback.sh
├── monitoring/             # Scripts de monitoramento
│   ├── health-check.sh
│   └── backup-db.sh
└── utils/                  # Scripts utilitários
    ├── generate-types.sh
    └── lint-all.sh
```

## Configurações de Ambiente
```
.env.example               # Template de variáveis de ambiente
.env.development          # Ambiente de desenvolvimento
.env.staging              # Ambiente de staging
.env.production           # Ambiente de produção
```

## Principais Dependências

### Frontend:
- React 18 + TypeScript
- Three.js + @react-three/fiber + @react-three/drei
- Framer Motion
- Tailwind CSS + Shadcn/ui
- Redux Toolkit / Zustand
- Axios / React Query
- Socket.io-client

### Backend:
- FastAPI + Uvicorn
- SQLModel (SQLAlchemy + Pydantic)
- PostgreSQL + asyncpg
- Redis + aioredis
- Celery + Redis (tarefas assíncronas)
- OpenAI Python SDK / Anthropic SDK
- Pydantic (validação)
- Alembic (migrações)

### DevOps:
- Docker + Docker Compose
- Nginx
- GitHub Actions / GitLab CI
- Prometheus + Grafana
- Sentry (error tracking)

## Estrutura de Banco de Dados
```
tjuridico_db/
├── public.leads
├── public.conversations
├── public.messages
├── public.ai_agents
├── public.legal_knowledge
├── public.animation_logs
├── public.user_sessions
└── public.analytics_events
```

Esta estrutura segue os princípios de separação de responsabilidades, modularidade e escalabilidade, permitindo o desenvolvimento paralelo das equipes frontend e backend.