# Project Summary
The Tjuridico project is a dynamic platform designed to revolutionize the legal sector by utilizing advanced AI agents for customer service and lead generation. It enhances legal practices through an interactive user experience that improves client engagement and operational efficiency.

# Project Module Description
- **Frontend**: Developed with React and TypeScript, leveraging Shadcn-ui and Tailwind CSS for a responsive and visually appealing interface.
- **Backend**: Powered by FastAPI, providing efficient API services that facilitate communication between AI agents and database management.
- **AI Integration**: Features a multi-agent system for legal assistance, customer support, and compliance monitoring.
- **Animations**: Utilizes Three.js for 3D animations and Framer Motion for micro-interactions to elevate user engagement.
- **Hero Section**: Now includes a static background with particle animations, enhancing the visual experience without a banner carousel.
- **Testimonials Section**: Displays client feedback through an interactive carousel.

# Directory Tree
```
tjuridico-website/
├── frontend/                 # React/TypeScript Application
│   ├── public/              # Public assets
│   ├── src/                 # Source files
│   │   ├── components/      # UI components
│   │   ├── pages/           # Application pages
│   │   └── styles/          # Global styles
├── backend/                  # API FastAPI
│   ├── src/                 # Source files
│   │   └── api/             # API routes
├── shared/                   # Shared code
├── infrastructure/           # Infrastructure configuration
└── docs/                     # Documentation
```

# File Description Inventory
- **`frontend/src/components/layout/Navbar.tsx`**: Navigation bar component with responsive design.
- **`frontend/src/components/layout/Footer.tsx`**: Footer component with contact information and social links.
- **`frontend/src/pages/Home.tsx`**: Home page integrating various sections.
- **`frontend/src/components/sections/Hero.tsx`**: Hero section with static background and particle animations.
- **`frontend/src/components/sections/Services.tsx`**: Displays available legal services.
- **`frontend/src/components/sections/AIAgents.tsx`**: Showcases AI agents and their capabilities.
- **`frontend/src/components/sections/Plans.tsx`**: Pricing plans with features comparison.
- **`frontend/src/components/sections/Contact.tsx`**: Contact form for user inquiries.
- **`frontend/src/components/sections/Testimonials.tsx`**: Interactive testimonials section displaying client feedback.
- **`frontend/src/components/chatbot/Chatbot.tsx`**: Interactive chatbot for user assistance.

# Technology Stack
- **Frontend**: React 18, TypeScript, Tailwind CSS, Shadcn-ui
- **Backend**: FastAPI, PostgreSQL, Redis
- **Animations**: Three.js, Framer Motion, Particle.js
- **State Management**: React Context, TanStack Query
- **Routing**: React Router DOM
- **Forms**: React Hook Form with Zod validation
- **Icons**: Lucide React
- **Charts**: Recharts for data visualization

# Usage
1. **Install Dependencies**: 
   - Run `pnpm install` to install all necessary packages.
2. **Build the Project**: 
   - Run `pnpm run build` to create a production build.
3. **Run the Application**: 
   - Use the appropriate command to start the server locally.
